/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.regex.Pattern;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00120", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadPackageName_S00120_Check
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT_FORMAT = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";
    @RuleProperty(key="format", defaultValue="^[a-z]+(\\.[a-z][a-z0-9]*)*$")
    public String format = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";
    private Pattern pattern = null;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.PACKAGE_DECLARATION});
        this.pattern = Pattern.compile(this.format, 32);
    }

    public void visitNode(AstNode astNode) {
        String name = this.concatenate(astNode.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}));
        if (!this.pattern.matcher(name).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this package name to match the regular expression '" + this.format + "'.", astNode, new Object[0]);
        }
    }

    private String concatenate(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (Token token : astNode.getTokens()) {
            sb.append(token.getValue());
        }
        return sb.toString();
    }
}

