/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S1125", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class BooleanEqualityComparisonCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1125";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1125");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        String operator = BooleanEqualityComparisonCheck.operator((Tree)tree);
        if (operator != null && BooleanEqualityComparisonCheck.hasBooleanLiteralOperands(tree)) {
            this.addIssue((Tree)tree, operator);
        }
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        super.visitUnaryExpression(tree);
        String operator = BooleanEqualityComparisonCheck.operator((Tree)tree);
        if (operator != null && BooleanEqualityComparisonCheck.isBooleanLiteral((Tree)tree.expression())) {
            this.addIssue((Tree)tree, operator);
        }
    }

    private void addIssue(Tree tree, String operator) {
        this.context.addIssue(tree, RULE, "Remove the useless \"" + operator + "\" operator.");
    }

    private static boolean hasBooleanLiteralOperands(BinaryExpressionTree tree) {
        return BooleanEqualityComparisonCheck.isBooleanLiteral((Tree)tree.leftOperand()) || BooleanEqualityComparisonCheck.isBooleanLiteral((Tree)tree.rightOperand());
    }

    private static boolean isBooleanLiteral(Tree tree) {
        return tree.is(Tree.Kind.BOOLEAN_LITERAL);
    }

    private static String operator(Tree tree) {
        String result = tree.is(Tree.Kind.EQUAL_TO) ? "==" : (tree.is(Tree.Kind.NOT_EQUAL_TO) ? "!=" : (tree.is(Tree.Kind.CONDITIONAL_AND) ? "&&" : (tree.is(Tree.Kind.CONDITIONAL_OR) ? "||" : (tree.is(Tree.Kind.LOGICAL_COMPLEMENT) ? "!" : null))));
        return result;
    }
}

