/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1166", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CatchUsesExceptionWithContextCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1166";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1166");
    private static final Set<String> EXCLUDED_EXCEPTION_TYPE = ImmutableSet.of((Object)"NumberFormatException", (Object)"InterruptedException", (Object)"ParseException", (Object)"MalformedURLException");
    private static final Set<String> JAVA_SUB_PACKAGE = ImmutableSet.of((Object)"lang", (Object)"text", (Object)"net");
    private JavaFileScannerContext context;
    private final Set<CatchTree> invalidCatchesCheck = Sets.newHashSet();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCatch(CatchTree tree) {
        this.invalidCatchesCheck.add(tree);
        super.visitCatch(tree);
        if (this.invalidCatchesCheck.contains(tree)) {
            this.invalidCatchesCheck.remove(tree);
            if (!CatchUsesExceptionWithContextCheck.isExcludedType(tree.parameter().type())) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Either log or rethrow this exception along with some contextual information.");
            }
        }
    }

    private static boolean isExcludedType(Tree tree) {
        return CatchUsesExceptionWithContextCheck.isUnqualifiedExcludedType(tree) || CatchUsesExceptionWithContextCheck.isQualifiedExcludedType(tree);
    }

    private static boolean isUnqualifiedExcludedType(Tree tree) {
        return tree.is(Tree.Kind.IDENTIFIER) && EXCLUDED_EXCEPTION_TYPE.contains(((IdentifierTree)tree).name());
    }

    private static boolean isQualifiedExcludedType(Tree tree) {
        if (!tree.is(Tree.Kind.MEMBER_SELECT)) {
            return false;
        }
        MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)tree;
        if (!EXCLUDED_EXCEPTION_TYPE.contains(memberSelectExpressionTree.identifier().name()) || !memberSelectExpressionTree.expression().is(Tree.Kind.MEMBER_SELECT)) {
            return false;
        }
        if (!JAVA_SUB_PACKAGE.contains((memberSelectExpressionTree = (MemberSelectExpressionTree)memberSelectExpressionTree.expression()).identifier().name()) || !memberSelectExpressionTree.expression().is(Tree.Kind.IDENTIFIER)) {
            return false;
        }
        IdentifierTree identifierTree = (IdentifierTree)memberSelectExpressionTree.expression();
        return "java".equals(identifierTree.name());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        super.visitMethodInvocation(tree);
        if (tree.arguments().size() >= 2) {
            this.handleArguments(tree.arguments());
        }
    }

    private void removeInvalidCatches(String exceptionName) {
        Iterator<CatchTree> it = this.invalidCatchesCheck.iterator();
        while (it.hasNext()) {
            CatchTree tree = it.next();
            if (!exceptionName.equals(tree.parameter().simpleName())) continue;
            it.remove();
        }
    }

    private void handleArguments(List<ExpressionTree> trees) {
        for (Tree tree : trees) {
            if (!tree.is(Tree.Kind.IDENTIFIER)) continue;
            this.removeInvalidCatches(((IdentifierTree)tree).name());
        }
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        super.visitThrowStatement(tree);
        this.allowIfExceptionInExpression(tree.expression(), true);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.allowIfExceptionInExpression(tree.expression(), true);
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        if (tree.initializer() != null) {
            this.allowIfExceptionInExpression(tree.initializer(), true);
        }
    }

    private void allowIfExceptionInExpression(ExpressionTree tree, boolean allowIdentifier) {
        if (tree.is(Tree.Kind.IDENTIFIER) && allowIdentifier) {
            this.removeInvalidCatches(((IdentifierTree)tree).name());
        } else if (tree.is(Tree.Kind.NEW_CLASS)) {
            NewClassTree newClassTree = (NewClassTree)tree;
            this.handleArguments(newClassTree.arguments());
        } else if (tree.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            this.allowIfExceptionInExpression(methodInvocationTree.methodSelect(), false);
            this.handleArguments(methodInvocationTree.arguments());
        } else if (tree.is(Tree.Kind.TYPE_CAST)) {
            this.allowIfExceptionInExpression(((TypeCastTree)tree).expression(), allowIdentifier);
        } else if (tree.is(Tree.Kind.MEMBER_SELECT)) {
            this.allowIfExceptionInExpression(((MemberSelectExpressionTree)tree).expression(), false);
        } else if (tree.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            this.allowIfExceptionInExpression(((ParenthesizedTree)tree).expression(), allowIdentifier);
        } else if (tree.is(Tree.Kind.CONDITIONAL_EXPRESSION)) {
            ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)tree;
            this.allowIfExceptionInExpression(conditionalExpressionTree.trueExpression(), allowIdentifier);
            this.allowIfExceptionInExpression(conditionalExpressionTree.falseExpression(), allowIdentifier);
        }
    }
}

