/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ClassVariableVisibilityCheck", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ClassVariableVisibilityCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.FIELD_DECLARATION});
    }

    public void visitNode(AstNode node) {
        AstNode classBodyDeclaration = node.getFirstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION);
        if (ClassVariableVisibilityCheck.isPublic(classBodyDeclaration) && !ClassVariableVisibilityCheck.isConstant(classBodyDeclaration) && !ClassVariableVisibilityCheck.isAnnotated(classBodyDeclaration)) {
            this.getContext().createLineViolation((CodeCheck)this, "Make this class field a static final constant or non-public and provide accessors if needed.", node, new Object[0]);
        }
    }

    private static boolean isConstant(AstNode node) {
        return ClassVariableVisibilityCheck.hasModifier(node, (AstNodeType)JavaKeyword.STATIC) && ClassVariableVisibilityCheck.hasModifier(node, (AstNodeType)JavaKeyword.FINAL);
    }

    private static boolean isPublic(AstNode node) {
        return ClassVariableVisibilityCheck.hasModifier(node, (AstNodeType)JavaKeyword.PUBLIC);
    }

    private static boolean hasModifier(AstNode node, AstNodeType modifier) {
        return node.select().children((AstNodeType)JavaGrammar.MODIFIER).children(modifier).isNotEmpty();
    }

    private static boolean isAnnotated(AstNode node) {
        return ClassVariableVisibilityCheck.hasModifier(node, (AstNodeType)JavaGrammar.ANNOTATION);
    }
}

