/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1066", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CollapsibleIfCandidateCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.IF_STATEMENT});
    }

    public void visitNode(AstNode node) {
        AstNode enclosingIfStatement;
        if (!CollapsibleIfCandidateCheck.hasElseClause(node) && (enclosingIfStatement = CollapsibleIfCandidateCheck.getEnclosingIfStatement(node)) != null && !CollapsibleIfCandidateCheck.hasElseClause(enclosingIfStatement) && CollapsibleIfCandidateCheck.hasSingleTrueStatement(enclosingIfStatement)) {
            this.getContext().createLineViolation((CodeCheck)this, "Merge this if statement with the enclosing one.", node, new Object[0]);
        }
    }

    private static boolean hasElseClause(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaKeyword.ELSE});
    }

    @Nullable
    private static AstNode getEnclosingIfStatement(AstNode node) {
        AstNode grandParent = node.getParent().getParent();
        if (grandParent.is(new AstNodeType[]{JavaGrammar.IF_STATEMENT})) {
            return grandParent;
        }
        if (!grandParent.is(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT})) {
            return null;
        }
        AstNode statement = grandParent.getFirstAncestor((AstNodeType)JavaGrammar.BLOCK).getParent();
        if (!statement.is(new AstNodeType[]{JavaGrammar.STATEMENT})) {
            return null;
        }
        AstNode enclosingStatement = statement.getParent();
        return enclosingStatement.is(new AstNodeType[]{JavaGrammar.IF_STATEMENT}) ? enclosingStatement : null;
    }

    private static boolean hasSingleTrueStatement(AstNode node) {
        AstNode statement = node.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT});
        return statement.hasDirectChildren(new AstNodeType[]{JavaGrammar.BLOCK}) ? statement.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK}).getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS}).getChildren().size() == 1 : true;
    }
}

