/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;

@Rule(key="MaximumInheritanceDepth", priority=Priority.MAJOR)
public class DITCheck
extends BytecodeVisitor {
    public static final String RULE_KEY = "MaximumInheritanceDepth";
    public static final int DEFAULT_MAX = 5;
    @RuleProperty(defaultValue="5")
    private Integer max = 5;

    public void visitClass(AsmClass asmClass) {
        SourceClass sourceClass = this.getSourceClass(asmClass);
        int dit = sourceClass.getInt(Metric.DIT);
        if (dit > this.max) {
            CheckMessage message = new CheckMessage((Object)this, "This class has " + dit + " parents which is greater than " + this.max + " authorized.", new Object[0]);
            message.setLine(sourceClass.getStartAtLine());
            message.setCost((double)(dit - this.max));
            ((SourceFile)sourceClass.getParent(SourceFile.class)).log(message);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }

    public String toString() {
        return "MaximumInheritanceDepth rule";
    }
}

