/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1194", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ErrorClassExtendedCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION});
    }

    public void visitNode(AstNode node) {
        AstNode extendedClass = node.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_TYPE});
        if (extendedClass != null && ErrorClassExtendedCheck.isErrorClass(extendedClass)) {
            this.getContext().createLineViolation((CodeCheck)this, "Extend \"java.lang.Exception\" or one of its subclasses.", node, new Object[0]);
        }
    }

    private static boolean isErrorClass(AstNode node) {
        return ErrorClassExtendedCheck.isError(node) || ErrorClassExtendedCheck.isJavaLangError(node);
    }

    private static boolean isError(AstNode node) {
        return "Error".equals(node.getTokenOriginalValue()) && !node.hasDirectChildren(new AstNodeType[]{JavaPunctuator.DOT});
    }

    private static boolean isJavaLangError(AstNode node) {
        List identifiers = node.getChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        return identifiers.size() == 3 && "java".equals(((AstNode)identifiers.get(0)).getTokenOriginalValue()) && "lang".equals(((AstNode)identifiers.get(1)).getTokenOriginalValue()) && "Error".equals(((AstNode)identifiers.get(2)).getTokenOriginalValue());
    }
}

