/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1067", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ExpressionComplexityCheck
extends SquidCheck<LexerlessGrammar> {
    private static final GrammarRuleKey[] OPERATORS = new GrammarRuleKey[]{JavaGrammar.CONDITIONAL_EXPRESSION, JavaGrammar.CONDITIONAL_OR_EXPRESSION, JavaGrammar.CONDITIONAL_AND_EXPRESSION};
    private static final GrammarRuleKey[] EXCLUSIONS = new GrammarRuleKey[]{JavaGrammar.CLASS_BODY, JavaGrammar.ARRAY_INITIALIZER};
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(defaultValue="3")
    public int max = 3;
    private final Stack<Integer> expressionNestingLevel = new Stack();
    private final Stack<Integer> operatorCounter = new Stack();

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.EXPRESSION});
        this.subscribeTo((AstNodeType[])OPERATORS);
        this.subscribeTo((AstNodeType[])EXCLUSIONS);
    }

    public void visitFile(AstNode node) {
        this.expressionNestingLevel.clear();
        this.operatorCounter.clear();
        this.pushExclusionLevel();
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.EXPRESSION})) {
            int level = this.getExpressionNestingLevel();
            this.setExpressionNestingLevel(++level);
            if (level == 1) {
                this.setOperatorCounter(0);
            }
        } else if (node.is((AstNodeType[])EXCLUSIONS)) {
            this.pushExclusionLevel();
        } else {
            this.setOperatorCounter(this.getOperatorCounter() + node.getChildren(new AstNodeType[]{JavaPunctuator.QUERY, JavaPunctuator.OROR, JavaPunctuator.ANDAND}).size());
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.EXPRESSION})) {
            int level = this.getExpressionNestingLevel();
            this.setExpressionNestingLevel(--level);
            if (level == 0 && this.getOperatorCounter() > this.max) {
                this.getContext().createLineViolation((CodeCheck)this, "Reduce the number of conditional operators (" + this.getOperatorCounter() + ") used in the expression (maximum allowed " + this.max + ").", node, new Object[0]);
            }
        } else if (node.is((AstNodeType[])EXCLUSIONS)) {
            this.popExclusionLevel();
        }
    }

    private void pushExclusionLevel() {
        this.expressionNestingLevel.push(0);
        this.operatorCounter.push(0);
    }

    private void popExclusionLevel() {
        this.expressionNestingLevel.pop();
        this.operatorCounter.pop();
    }

    private int getExpressionNestingLevel() {
        return this.expressionNestingLevel.peek();
    }

    private void setExpressionNestingLevel(int level) {
        this.expressionNestingLevel.pop();
        this.expressionNestingLevel.push(level);
    }

    private int getOperatorCounter() {
        return this.operatorCounter.peek();
    }

    private void setOperatorCounter(int count) {
        this.operatorCounter.pop();
        this.operatorCounter.push(count);
    }
}

