/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="IndentationCheck", priority=Priority.MAJOR)
public class IndentationCheck
extends SquidCheck<LexerlessGrammar> {
    private static final AstNodeType[] BLOCK_TYPES = new AstNodeType[]{JavaGrammar.CLASS_BODY, JavaGrammar.ENUM_BODY, JavaGrammar.INTERFACE_BODY, JavaGrammar.BLOCK, JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUPS, JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUP};
    private static final AstNodeType[] CHECKED_TYPES = new AstNodeType[]{JavaGrammar.TYPE_DECLARATION, JavaGrammar.CLASS_BODY_DECLARATION, JavaGrammar.INTERFACE_BODY_DECLARATION, JavaGrammar.BLOCK_STATEMENT};
    private static final int DEFAULT_INDENTATION_LEVEL = 2;
    @RuleProperty(key="indentationLevel", defaultValue="2")
    public int indentationLevel = 2;
    private int expectedLevel;
    private boolean isBlockAlreadyReported;
    private int lastCheckedLine;

    public void init() {
        this.subscribeTo(BLOCK_TYPES);
        this.subscribeTo(CHECKED_TYPES);
    }

    public void visitFile(AstNode node) {
        this.expectedLevel = 0;
        this.isBlockAlreadyReported = false;
        this.lastCheckedLine = 0;
    }

    public void visitNode(AstNode node) {
        if (node.is(BLOCK_TYPES)) {
            this.expectedLevel += this.indentationLevel;
            this.isBlockAlreadyReported = false;
        } else if (node.getToken().getColumn() != this.expectedLevel && !this.isExcluded(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Make this line start at column " + (this.expectedLevel + 1) + ".", node, new Object[0]);
            this.isBlockAlreadyReported = true;
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(BLOCK_TYPES)) {
            this.expectedLevel -= this.indentationLevel;
            this.isBlockAlreadyReported = false;
        }
        Token lastToken = IndentationCheck.getLastToken(node);
        this.lastCheckedLine = lastToken.getLine();
    }

    private boolean isExcluded(AstNode node) {
        return this.isBlockAlreadyReported || !this.isLineFirstStatement(node) || IndentationCheck.isInAnnonymousClass(node);
    }

    private boolean isLineFirstStatement(AstNode node) {
        return this.lastCheckedLine != node.getTokenLine();
    }

    private static boolean isInAnnonymousClass(AstNode node) {
        return node.hasAncestor((AstNodeType)JavaGrammar.CLASS_CREATOR_REST);
    }

    private static Token getLastToken(AstNode node) {
        AstNode lastNodeWithTokens = node;
        while (!lastNodeWithTokens.hasToken()) {
            lastNodeWithTokens = lastNodeWithTokens.getPreviousAstNode();
        }
        return lastNodeWithTokens.getLastToken();
    }
}

