/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1193", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class InstanceofUsedOnExceptionCheck
extends SquidCheck<LexerlessGrammar> {
    private final Set<String> caughtVariables = Sets.newHashSet();

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CATCH_CLAUSE});
        this.subscribeTo(new AstNodeType[]{JavaKeyword.INSTANCEOF});
    }

    public void visitFile(AstNode node) {
        this.caughtVariables.clear();
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.CATCH_CLAUSE})) {
            this.caughtVariables.add(InstanceofUsedOnExceptionCheck.getCaughtVariable(node));
        } else if (this.isLeftOperandAnException(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace the usage of the \"instanceof\" operator by a catch block.", node, new Object[0]);
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.CATCH_CLAUSE})) {
            this.caughtVariables.remove(InstanceofUsedOnExceptionCheck.getCaughtVariable(node));
        }
    }

    private static String getCaughtVariable(AstNode catchClause) {
        return catchClause.getFirstChild(new AstNodeType[]{JavaGrammar.CATCH_FORMAL_PARAMETER}).getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID}).getTokenOriginalValue();
    }

    private boolean isLeftOperandAnException(AstNode node) {
        AstNode leftOperand = node.getPreviousSibling();
        return leftOperand.getToken().equals(leftOperand.getLastToken()) && this.caughtVariables.contains(leftOperand.getTokenOriginalValue());
    }
}

