/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LeftCurlyBraceEndLineCheck", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class LeftCurlyBraceEndLineCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.LWING});
    }

    public void visitNode(AstNode node) {
        if (!LeftCurlyBraceEndLineCheck.isExcluded(node) && node.getPreviousAstNode().getLastToken().getLine() != node.getTokenLine()) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this left curly brace to the end of previous line of code.", node, new Object[0]);
        }
    }

    private static boolean isExcluded(AstNode node) {
        return node.getParent().is(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE_ARRAY_INITIALIZER, JavaGrammar.ARRAY_INITIALIZER}) || LeftCurlyBraceEndLineCheck.isExcludedBlock(node);
    }

    private static boolean isExcludedBlock(AstNode node) {
        AstNode parent = node.getParent();
        return parent.is(new AstNodeType[]{JavaGrammar.BLOCK}) && LeftCurlyBraceEndLineCheck.isStaticInitializer(parent) || LeftCurlyBraceEndLineCheck.isBlock(parent);
    }

    private static boolean isStaticInitializer(AstNode node) {
        return node.getParent().is(new AstNodeType[]{JavaGrammar.CLASS_INIT_DECLARATION});
    }

    private static boolean isBlock(AstNode node) {
        return node.getParent().is(new AstNodeType[]{JavaGrammar.STATEMENT}) && node.getParent().getParent().is(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT});
    }
}

