/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LeftCurlyBraceStartLineCheck", priority=Priority.MAJOR)
public class LeftCurlyBraceStartLineCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.LWING});
    }

    public void visitNode(AstNode node) {
        if (!LeftCurlyBraceStartLineCheck.isExcluded(node) && node.getPreviousAstNode().getLastToken().getLine() == node.getTokenLine()) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this left curly brace to the beginning of next line of code.", node, new Object[0]);
        }
    }

    private static boolean isExcluded(AstNode node) {
        return node.getParent().is(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE_ARRAY_INITIALIZER, JavaGrammar.ARRAY_INITIALIZER});
    }
}

