/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1312", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class LoggersDeclarationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String KEY = "S1312";
    private static final RuleKey RULE_KEY = RuleKey.of((String)"squid", (String)"S1312");
    private static final String DEFAULT_FORMAT = "LOG(?:GER)?";
    @RuleProperty(key="format", defaultValue="LOG(?:GER)?")
    public String format = "LOG(?:GER)?";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    private static boolean isPrivateStaticFinal(ModifiersTree tree) {
        return LoggersDeclarationCheck.hasModifier(tree, Modifier.PRIVATE) && LoggersDeclarationCheck.hasModifier(tree, Modifier.STATIC) && LoggersDeclarationCheck.hasModifier(tree, Modifier.FINAL);
    }

    private static boolean hasModifier(ModifiersTree tree, Modifier expectedModifier) {
        for (Modifier modifier : tree.modifiers()) {
            if (!modifier.equals((Object)expectedModifier)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidLoggerName(String name) {
        return this.pattern.matcher(name).matches();
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        if (LoggersDeclarationCheck.isLoggerType(tree.type())) {
            boolean isPrivateStaticFinal = LoggersDeclarationCheck.isPrivateStaticFinal(tree.modifiers());
            boolean hasValidLoggerName = this.isValidLoggerName(tree.simpleName());
            if (!isPrivateStaticFinal && !hasValidLoggerName) {
                this.context.addIssue((Tree)tree, RULE_KEY, LoggersDeclarationCheck.getPrivateStaticFinalMessage(tree.simpleName()) + " and rename it to comply with the format \"" + this.format + "\".");
            } else if (!isPrivateStaticFinal) {
                this.context.addIssue((Tree)tree, RULE_KEY, LoggersDeclarationCheck.getPrivateStaticFinalMessage(tree.simpleName()) + ".");
            } else if (!hasValidLoggerName) {
                this.context.addIssue((Tree)tree, RULE_KEY, "Rename the \"" + tree.simpleName() + "\" logger to comply with the format \"" + this.format + "\".");
            }
        }
    }

    private static String getPrivateStaticFinalMessage(String simpleName) {
        return "Make the \"" + simpleName + "\" logger private static final";
    }

    private static boolean isLoggerType(Tree tree) {
        if (!tree.is(Tree.Kind.IDENTIFIER)) {
            return false;
        }
        IdentifierTree identifierTree = (IdentifierTree)tree;
        return "Log".equals(identifierTree.name()) || "Logger".equals(identifierTree.name());
    }
}

