/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.java.checks.AstNodeTokensMatcher;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1201", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class MethodNamedEqualsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        MethodHelper.subscribe((SquidAstVisitor)this);
    }

    public void visitNode(AstNode node) {
        MethodHelper methodHelper = new MethodHelper(node);
        if ("equals".equalsIgnoreCase(methodHelper.getName().getTokenOriginalValue()) && !MethodNamedEqualsCheck.hasSingleObjectParameter(methodHelper)) {
            this.getContext().createLineViolation((CodeCheck)this, "Either override Object.equals(Object), or totally rename the method to prevent any confusion.", methodHelper.getName(), new Object[0]);
        }
    }

    private static boolean hasSingleObjectParameter(MethodHelper methodHelper) {
        List parameters = methodHelper.getParameters();
        if (parameters.size() != 1) {
            return false;
        }
        return MethodNamedEqualsCheck.isObjectType(((AstNode)parameters.get(0)).getFirstChild(new AstNodeType[]{JavaGrammar.TYPE}));
    }

    private static boolean isObjectType(AstNode node) {
        return AstNodeTokensMatcher.matches(node, "Object") || AstNodeTokensMatcher.matches(node, "java.lang.Object");
    }
}

