/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1185", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class MethodOnlyCallsSuperCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.VOID_METHOD_DECLARATOR_REST});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST});
    }

    public void visitNode(AstNode node) {
        List<String> parameters;
        String methodName;
        AstNode singleBlockStatement = MethodOnlyCallsSuperCheck.getSingleBlockStatement(node);
        if (singleBlockStatement != null && MethodOnlyCallsSuperCheck.isSuperOrReturnOfSuperReference(singleBlockStatement) && MethodOnlyCallsSuperCheck.isUselessSuperCall(singleBlockStatement, methodName = MethodOnlyCallsSuperCheck.getMethodName(node), parameters = MethodOnlyCallsSuperCheck.getParameters(node)) && !MethodOnlyCallsSuperCheck.hasAnnotationDifferentFromOverride(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this method to simply inherit it.", node, new Object[0]);
        }
    }

    private static AstNode getSingleBlockStatement(AstNode node) {
        AstNode methodBody = node.getFirstChild(new AstNodeType[]{JavaGrammar.METHOD_BODY});
        if (methodBody == null) {
            return null;
        }
        AstNode blockStatements = methodBody.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK}).getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS});
        return blockStatements.getNumberOfChildren() == 1 ? blockStatements.getFirstChild() : null;
    }

    private static boolean isSuperOrReturnOfSuperReference(AstNode node) {
        return MethodOnlyCallsSuperCheck.isSuperReference(node) || MethodOnlyCallsSuperCheck.isReturnOfSuperReference(node);
    }

    private static boolean isSuperReference(AstNode node) {
        return "super".equals(node.getTokenOriginalValue());
    }

    private static boolean isReturnOfSuperReference(AstNode node) {
        return "return".equals(node.getTokenOriginalValue()) && MethodOnlyCallsSuperCheck.hasSuperReferenceReturnedExpression(node);
    }

    private static boolean hasSuperReferenceReturnedExpression(AstNode node) {
        AstNode returnStatement = node.getFirstDescendant(new AstNodeType[]{JavaGrammar.RETURN_STATEMENT});
        AstNode expression = returnStatement.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION});
        return expression != null && MethodOnlyCallsSuperCheck.isSuperReference(expression);
    }

    private static String getMethodName(AstNode node) {
        return node.getParent().getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenOriginalValue();
    }

    private static List<String> getParameters(AstNode node) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AstNode parameter : node.getFirstChild(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETERS}).getDescendants(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID})) {
            builder.add((Object)parameter.getTokenOriginalValue());
        }
        return builder.build();
    }

    private static boolean isUselessSuperCall(AstNode node, String methodName, List<String> parameters) {
        String expected;
        StringBuilder sb = new StringBuilder();
        for (Token token : node.getTokens()) {
            sb.append(token.getOriginalValue());
        }
        String actual = sb.toString();
        return actual.equals(expected = "super." + methodName + "(" + Joiner.on((char)',').join(parameters) + ");") || actual.equals("return" + expected);
    }

    private static boolean hasAnnotationDifferentFromOverride(AstNode node) {
        AstSelect query = node.select().firstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).children((AstNodeType)JavaGrammar.MODIFIER).children((AstNodeType)JavaGrammar.ANNOTATION).children((AstNodeType)JavaGrammar.QUALIFIED_IDENTIFIER);
        for (AstNode qualifiedIdentifier : query) {
            if (MethodOnlyCallsSuperCheck.isOverride(qualifiedIdentifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverride(AstNode node) {
        return node.getToken().equals(node.getLastToken()) && "Override".equals(node.getTokenOriginalValue());
    }
}

