/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S138", priority=Priority.MAJOR)
public class MethodTooBigCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 100;
    @RuleProperty(defaultValue="100")
    public int max = 100;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.METHOD_BODY});
    }

    public void visitNode(AstNode node) {
        int lines = MethodTooBigCheck.getLines(node);
        if (lines > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "This method has " + lines + " lines, which is greater than the " + this.max + " lines authorized. Split it into smaller methods.", node, new Object[0]);
        }
    }

    private static int getLines(AstNode node) {
        AstNode block = node.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK});
        AstNode leftCurlyBrace = block.getFirstChild(new AstNodeType[]{JavaPunctuator.LWING});
        AstNode rightCurlyBrace = block.getFirstChild(new AstNodeType[]{JavaPunctuator.RWING});
        return rightCurlyBrace.getTokenLine() - leftCurlyBrace.getTokenLine() + 1;
    }
}

