/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractDeprecatedChecker;
import org.sonar.squid.api.CodeCheck;

@Rule(key="MissingDeprecatedCheck", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class MissingDeprecatedCheck
extends AbstractDeprecatedChecker {
    public void visitNode(AstNode node) {
        boolean hasDeprecatedAnnotation = MissingDeprecatedCheck.hasDeprecatedAnnotationExcludingLocalVariables(node);
        boolean hasJavadocDeprecatedTag = MissingDeprecatedCheck.hasJavadocDeprecatedTag(node);
        if (hasDeprecatedAnnotation && !hasJavadocDeprecatedTag) {
            this.getContext().createLineViolation((CodeCheck)this, "Add the missing @deprecated Javadoc tag.", node, new Object[0]);
        } else if (hasJavadocDeprecatedTag && !hasDeprecatedAnnotation) {
            this.getContext().createLineViolation((CodeCheck)this, "Add the missing @Deprecated annotation.", node, new Object[0]);
        }
    }
}

