/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ModifiersOrderCheck", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class ModifiersOrderCheck
extends SquidCheck<LexerlessGrammar> {
    private static final AstNodeType[] EXPECTED_ORDER = new AstNodeType[]{JavaGrammar.ANNOTATION, JavaKeyword.PUBLIC, JavaKeyword.PROTECTED, JavaKeyword.PRIVATE, JavaKeyword.ABSTRACT, JavaKeyword.STATIC, JavaKeyword.FINAL, JavaKeyword.TRANSIENT, JavaKeyword.VOLATILE, JavaKeyword.SYNCHRONIZED, JavaKeyword.NATIVE, JavaKeyword.STRICTFP};

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.MODIFIER});
    }

    public void visitNode(AstNode node) {
        List<AstNode> modifiers;
        if (ModifiersOrderCheck.isFirstModifer(node) && ModifiersOrderCheck.isBadlyOrdered(modifiers = ModifiersOrderCheck.getModifiers(node))) {
            this.getContext().createLineViolation((CodeCheck)this, "Reorder the modifiers to comply with the Java Language Specification.", node, new Object[0]);
        }
    }

    private static boolean isFirstModifer(AstNode node) {
        return node.getPreviousSibling() == null;
    }

    private static List<AstNode> getModifiers(AstNode node) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)node);
        for (AstNode nextSibling = node.getNextSibling(); nextSibling != null && nextSibling.is(new AstNodeType[]{JavaGrammar.MODIFIER}); nextSibling = nextSibling.getNextSibling()) {
            builder.add((Object)nextSibling);
        }
        return builder.build();
    }

    private static boolean isBadlyOrdered(List<AstNode> modifiers) {
        int i = 0;
        for (AstNode modifier : modifiers) {
            while (i < EXPECTED_ORDER.length && !modifier.getFirstChild().is(new AstNodeType[]{EXPECTED_ORDER[i]})) {
                ++i;
            }
        }
        return i == EXPECTED_ORDER.length;
    }
}

