/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S134", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class NestedIfStatementsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String KEY = "S134";
    private static final RuleKey RULE_KEY = RuleKey.of((String)"squid", (String)"S134");
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(defaultValue="3")
    public int max = 3;
    private JavaFileScannerContext context;
    private int nestingLevel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.nestingLevel = 0;
        this.scan((Tree)context.getTree());
    }

    public void visitIfStatement(IfStatementTree tree) {
        ++this.nestingLevel;
        this.checkNesting((Tree)tree);
        this.visit(tree);
        --this.nestingLevel;
    }

    public void visitForStatement(ForStatementTree tree) {
        ++this.nestingLevel;
        this.checkNesting((Tree)tree);
        super.visitForStatement(tree);
        --this.nestingLevel;
    }

    public void visitForEachStatement(ForEachStatement tree) {
        ++this.nestingLevel;
        this.checkNesting((Tree)tree);
        super.visitForEachStatement(tree);
        --this.nestingLevel;
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        ++this.nestingLevel;
        this.checkNesting((Tree)tree);
        super.visitWhileStatement(tree);
        --this.nestingLevel;
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        ++this.nestingLevel;
        this.checkNesting((Tree)tree);
        super.visitDoWhileStatement(tree);
        --this.nestingLevel;
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        ++this.nestingLevel;
        this.checkNesting((Tree)tree);
        super.visitSwitchStatement(tree);
        --this.nestingLevel;
    }

    public void visitTryStatement(TryStatementTree tree) {
        ++this.nestingLevel;
        this.checkNesting((Tree)tree);
        this.scan((Tree)tree.block());
        --this.nestingLevel;
        this.scan(tree.resources());
        this.scan(tree.catches());
        this.scan((Tree)tree.finallyBlock());
    }

    private void checkNesting(Tree tree) {
        if (this.nestingLevel == this.max + 1) {
            this.context.addIssue(tree, RULE_KEY, "Refactor this code to not nest more than " + this.max + " if/for/while/switch/try statements.");
        }
    }

    private void visit(IfStatementTree tree) {
        this.scan((Tree)tree.condition());
        this.scan((Tree)tree.thenStatement());
        StatementTree elseStatementTree = tree.elseStatement();
        if (elseStatementTree != null && elseStatementTree.is(Tree.Kind.IF_STATEMENT)) {
            this.visit((IfStatementTree)elseStatementTree);
        } else {
            this.scan((Tree)elseStatementTree);
        }
    }
}

