/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ObjectFinalizeCheck", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ObjectFinalizeCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private State state = State.EXPECT_FINALIZE;
    private boolean isInFinalizeMethod;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.MEMBER_DECL});
    }

    public void visitFile(AstNode node) {
        this.isInFinalizeMethod = false;
    }

    public void visitNode(AstNode node) {
        if (ObjectFinalizeCheck.isFinalizeMethodMember(node)) {
            this.isInFinalizeMethod = true;
        }
    }

    public void leaveNode(AstNode node) {
        if (ObjectFinalizeCheck.isFinalizeMethodMember(node)) {
            this.isInFinalizeMethod = false;
        }
    }

    public void visitToken(Token token) {
        switch (this.state) {
            case EXPECT_FINALIZE: {
                this.transitionIfMatch(token, "finalize", State.EXPECT_LPAREN);
                break;
            }
            case EXPECT_LPAREN: {
                this.transitionIfMatch(token, "(", State.EXPECT_RPAREN);
                break;
            }
            case EXPECT_RPAREN: {
                this.transitionIfMatch(token, ")", State.EXPECT_SEMI);
                break;
            }
            case EXPECT_SEMI: {
                if (";".equals(token.getOriginalValue()) && !this.isInFinalizeMethod) {
                    this.getContext().createLineViolation((CodeCheck)this, "Remove this call to finalize().", token, new Object[0]);
                }
                this.state = State.EXPECT_FINALIZE;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void transitionIfMatch(Token token, String expected, State target) {
        this.state = expected.equals(token.getOriginalValue()) ? target : State.EXPECT_FINALIZE;
    }

    private static boolean isFinalizeMethodMember(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaGrammar.VOID_METHOD_DECLARATOR_REST}) && "finalize".equals(node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenOriginalValue());
    }

    static enum State {
        EXPECT_FINALIZE,
        EXPECT_LPAREN,
        EXPECT_RPAREN,
        EXPECT_SEMI;

    }
}

