/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1226", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ParameterReassignedToCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1226";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1226");
    private final Set<String> variables = Sets.newHashSet();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.variables.clear();
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        for (VariableTree parameterTree : tree.parameters()) {
            this.variables.add(parameterTree.simpleName());
        }
        super.visitMethod(tree);
        for (VariableTree parameterTree : tree.parameters()) {
            this.variables.remove(parameterTree.simpleName());
        }
    }

    public void visitCatch(CatchTree tree) {
        this.variables.add(tree.parameter().simpleName());
        super.visitCatch(tree);
        this.variables.remove(tree.parameter().simpleName());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.checkExpression(tree.variable());
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (ParameterReassignedToCheck.isIncrementOrDecrement((Tree)tree) && tree.expression().is(Tree.Kind.IDENTIFIER)) {
            this.checkExpression(tree.expression());
        }
    }

    private static boolean isIncrementOrDecrement(Tree tree) {
        return tree.is(Tree.Kind.PREFIX_INCREMENT) || tree.is(Tree.Kind.PREFIX_DECREMENT) || tree.is(Tree.Kind.POSTFIX_INCREMENT) || tree.is(Tree.Kind.POSTFIX_DECREMENT);
    }

    private void checkExpression(ExpressionTree tree) {
        IdentifierTree identifier;
        if (tree.is(Tree.Kind.IDENTIFIER) && this.variables.contains((identifier = (IdentifierTree)tree).name())) {
            this.context.addIssue((Tree)identifier, this.ruleKey, "Introduce a new variable instead of reusing the parameter \"" + identifier.name() + "\".");
        }
    }
}

