/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Collections;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00112", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RawException_S00112_Check
extends SquidCheck<LexerlessGrammar> {
    private static final Set<String> RAW_EXCEPTIONS = ImmutableSet.of((Object)"Throwable", (Object)"Error", (Object)"Exception", (Object)"RuntimeException");

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.THROW_STATEMENT});
        this.subscribeTo(new AstNodeType[]{JavaKeyword.THROWS});
    }

    public void visitNode(AstNode node) {
        for (AstNode nameNode : RawException_S00112_Check.getExceptionNameNodes(node)) {
            String name = RawException_S00112_Check.merge(nameNode);
            if (!RAW_EXCEPTIONS.contains(name)) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Define and throw a dedicated exception instead of using a generic one.", nameNode, new Object[0]);
        }
    }

    private static Iterable<AstNode> getExceptionNameNodes(AstNode node) {
        return node.is(new AstNodeType[]{JavaGrammar.THROW_STATEMENT}) ? RawException_S00112_Check.getThrowStatementExceptionNames(node) : RawException_S00112_Check.getThrowsDeclarationExceptionNames(node);
    }

    private static Iterable<AstNode> getThrowStatementExceptionNames(AstNode node) {
        AstNode primary = node.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION}).getFirstChild(new AstNodeType[]{JavaGrammar.PRIMARY});
        if (primary == null || primary.getFirstChild().isNot(new AstNodeType[]{JavaKeyword.NEW})) {
            return Collections.EMPTY_LIST;
        }
        AstNode createdName = primary.getFirstDescendant(new AstNodeType[]{JavaGrammar.CREATED_NAME});
        if (createdName == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singleton(createdName);
    }

    private static Iterable<AstNode> getThrowsDeclarationExceptionNames(AstNode node) {
        AstNode qualifiedIdentifierList = node.getNextSibling();
        return qualifiedIdentifierList.getChildren(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
    }

    private static String merge(AstNode node) {
        StringBuilder sb = new StringBuilder();
        for (Token token : node.getTokens()) {
            sb.append(token.getValue());
        }
        return sb.toString();
    }
}

