/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RightCurlyBraceStartLineCheck", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RightCurlyBraceStartLineCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.RWING});
    }

    public void visitNode(AstNode node) {
        if (!RightCurlyBraceStartLineCheck.isExcluded(node) && RightCurlyBraceStartLineCheck.hasSomeCodeBefore(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this closing curly brace to the next line.", node, new Object[0]);
        }
    }

    private static boolean hasSomeCodeBefore(AstNode node) {
        Token previousToken = RightCurlyBraceStartLineCheck.getPreviousToken(node);
        return previousToken != null && previousToken.getLine() == node.getTokenLine();
    }

    private static boolean isExcluded(AstNode node) {
        return node.getParent().is(new AstNodeType[]{JavaGrammar.ELEMENT_VALUE_ARRAY_INITIALIZER, JavaGrammar.ARRAY_INITIALIZER});
    }

    private static Token getPreviousToken(AstNode node) {
        AstNode result = node.getPreviousAstNode();
        while (result != null && !result.hasToken()) {
            while (result != null && !result.hasToken()) {
                result = result.getPreviousAstNode();
            }
            while (result != null && result.getLastChild() != null) {
                result = result.getLastChild();
            }
        }
        return result == null ? null : result.getToken();
    }
}

