/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S135", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SeveralBreakOrContinuePerLoopCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int IS_SWITCH = -1;
    private final Stack<Integer> loopLines = new Stack();
    private final Stack<Integer> breakAndContinueCounter = new Stack();
    private static final JavaGrammar[] LOOP_NODES = new JavaGrammar[]{JavaGrammar.FOR_STATEMENT, JavaGrammar.WHILE_STATEMENT, JavaGrammar.DO_STATEMENT};

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.SWITCH_STATEMENT});
        this.subscribeTo((AstNodeType[])LOOP_NODES);
        this.subscribeTo(new AstNodeType[]{JavaGrammar.BREAK_STATEMENT});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CONTINUE_STATEMENT});
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.SWITCH_STATEMENT})) {
            this.enterSwitch();
        } else if (node.is((AstNodeType[])LOOP_NODES)) {
            this.enterLoop(node.getTokenLine());
        } else if (this.isInsideLoopOrSwitch() && !node.is(new AstNodeType[]{JavaGrammar.BREAK_STATEMENT}) || this.isInLoop()) {
            this.incrementLoopBreakAndContinueCounter();
        }
    }

    public void leaveNode(AstNode node) {
        if (!node.is(new AstNodeType[]{JavaGrammar.CONTINUE_STATEMENT, JavaGrammar.BREAK_STATEMENT})) {
            if (this.isInLoop() && this.breakAndContinueCounter.peek() > 1) {
                this.getContext().createLineViolation((CodeCheck)this, "Reduce the number of break and continue statement of this loop from " + this.breakAndContinueCounter.peek() + " to at most 1.", node, new Object[0]);
            }
            this.leave();
        }
    }

    private boolean isInsideLoopOrSwitch() {
        for (Integer line : this.loopLines) {
            if (line == -1) continue;
            return true;
        }
        return false;
    }

    private void incrementLoopBreakAndContinueCounter() {
        for (int i = this.loopLines.size() - 1; i >= 0; --i) {
            if ((Integer)this.loopLines.get(i) == -1) continue;
            int count = (Integer)this.breakAndContinueCounter.get(i);
            this.breakAndContinueCounter.set(i, count + 1);
        }
    }

    private void enterSwitch() {
        this.enter(-1);
    }

    private void enterLoop(int line) {
        this.enter(line);
    }

    private void enter(int line) {
        this.loopLines.push(line);
        this.breakAndContinueCounter.push(0);
    }

    private boolean isInLoop() {
        return !this.loopLines.isEmpty() && this.loopLines.peek() != -1;
    }

    private void leave() {
        this.loopLines.pop();
        this.breakAndContinueCounter.pop();
    }
}

