/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="StringEqualityComparisonCheck", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class StringEqualityComparisonCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.EQUALITY_EXPRESSION});
    }

    public void visitNode(AstNode node) {
        if (StringEqualityComparisonCheck.hasStringLiteralOperand(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace \"==\" and \"!=\" by \"equals()\" and \"!equals()\" respectively to compare these strings.", node, new Object[0]);
        }
    }

    private static boolean hasStringLiteralOperand(AstNode node) {
        return node.select().children((AstNodeType)JavaGrammar.PRIMARY).children((AstNodeType)JavaGrammar.LITERAL).descendants((AstNodeType)JavaTokenType.LITERAL).isNotEmpty();
    }
}

