/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1192", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class StringLiteralDuplicatedCheck
extends SquidCheck<LexerlessGrammar> {
    private static final Integer MINIMAL_LITERAL_LENGTH = 7;
    private final Map<String, Integer> firstOccurrence = Maps.newHashMap();
    private final Map<String, Integer> literalsOccurrences = Maps.newHashMap();
    private boolean inAnnotation;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.ANNOTATION_REST});
        this.subscribeTo(new AstNodeType[]{JavaTokenType.LITERAL});
    }

    public void visitFile(AstNode node) {
        this.inAnnotation = false;
        this.firstOccurrence.clear();
        this.literalsOccurrences.clear();
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.ANNOTATION_REST})) {
            this.inAnnotation = true;
        } else if (!this.inAnnotation) {
            this.visitOccurence(node.getTokenOriginalValue(), node.getTokenLine());
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.ANNOTATION_REST})) {
            this.inAnnotation = false;
        }
    }

    public void leaveFile(AstNode node) {
        for (Map.Entry<String, Integer> literalOccurences : this.literalsOccurrences.entrySet()) {
            Integer occurences = literalOccurences.getValue();
            if (occurences <= 1) continue;
            String literal = literalOccurences.getKey();
            this.getContext().createLineViolation((CodeCheck)this, "Define a constant instead of duplicating this literal " + literal + " " + occurences + " times.", this.firstOccurrence.get(literal).intValue(), new Object[0]);
        }
    }

    private void visitOccurence(String literal, int line) {
        if (literal.length() >= MINIMAL_LITERAL_LENGTH) {
            if (!this.firstOccurrence.containsKey(literal)) {
                this.firstOccurrence.put(literal, line);
                this.literalsOccurrences.put(literal, 1);
            } else {
                int occurences = this.literalsOccurrences.get(literal);
                this.literalsOccurrences.put(literal, occurences + 1);
            }
        }
    }
}

