/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1191", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SunPackagesUsedCheck
extends SquidCheck<LexerlessGrammar> {
    private int lastReportedLine;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_TYPE});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CREATED_NAME});
    }

    public void visitFile(AstNode node) {
        this.lastReportedLine = -1;
    }

    public void visitNode(AstNode node) {
        if (this.lastReportedLine != node.getTokenLine() && SunPackagesUsedCheck.isSunClass(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this usage of Sun classes by ones from the Java API.", node, new Object[0]);
            this.lastReportedLine = node.getTokenLine();
        }
    }

    private static boolean isSunClass(AstNode node) {
        String reference = SunPackagesUsedCheck.merge(node);
        return reference.startsWith("com.sun.") || reference.startsWith("sun.");
    }

    private static String merge(AstNode node) {
        StringBuilder sb = new StringBuilder();
        for (Token token : node.getTokens()) {
            sb.append(token.getOriginalValue());
        }
        return sb.toString();
    }
}

