/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1151", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SwitchCaseTooBigCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 5;
    @RuleProperty(defaultValue="5")
    public int max = 5;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUP});
    }

    public void visitNode(AstNode node) {
        int lines = SwitchCaseTooBigCheck.getNumberOfLines(node);
        if (lines > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "Reduce this switch case number of lines from " + lines + " to at most " + this.max + ", for example by extracting code into methods.", node, new Object[0]);
        }
    }

    private static int getNumberOfLines(AstNode node) {
        return Math.max(node.getNextAstNode().getTokenLine() - node.getTokenLine(), 1);
    }
}

