/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S128", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SwitchCaseWithoutBreakCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S128";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S128");
    private JavaFileScannerContext context;
    private final Set<CaseGroupTree> invalidCaseGroups = Sets.newHashSet();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCaseGroup(CaseGroupTree tree) {
        this.invalidCaseGroups.add(tree);
        super.visitCaseGroup(tree);
        boolean wasInInvalidSet = this.invalidCaseGroups.remove(tree);
        if (wasInInvalidSet) {
            this.context.addIssue((Tree)Iterables.getLast((Iterable)tree.labels()), this.ruleKey, "End this switch case with an unconditional break, continue, return or throw statement.");
        }
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        super.visitBreakStatement(tree);
        this.markSwitchCasesAsCompliant();
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        super.visitContinueStatement(tree);
        this.markSwitchCasesAsCompliant();
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        this.markSwitchCasesAsCompliant();
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        super.visitThrowStatement(tree);
        this.markSwitchCasesAsCompliant();
    }

    private void markSwitchCasesAsCompliant() {
        this.invalidCaseGroups.clear();
    }
}

