/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;

@Rule(key="S1217", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ThreadRunCheck
extends BytecodeVisitor {
    public static final String RULE_KEY = "S1217";
    private static final String THREAD_CLASS = "java/lang/Thread";
    private static final String RUNNABLE_CLASS = "java/lang/Runnable";
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitEdge(AsmEdge edge) {
        if (ThreadRunCheck.isCallToRun(edge) && ThreadRunCheck.isThreadOrRunnable(edge.getTargetAsmClass())) {
            edge.getTo();
            SourceFile sourceFile = this.getSourceFile(this.asmClass);
            CheckMessage message = new CheckMessage((Object)this, "Call the method Thread.start() to execute the content of the run() method in a dedicated thread.", new Object[0]);
            message.setLine(edge.getSourceLineNumber());
            sourceFile.log(message);
        }
    }

    private static boolean isCallToRun(AsmEdge edge) {
        return edge.getTo() instanceof AsmMethod && "run()V".equals(((AsmMethod)edge.getTo()).getKey());
    }

    private static boolean isThreadOrRunnable(AsmClass asmClass) {
        for (AsmClass currentClass = asmClass; currentClass != null; currentClass = currentClass.getSuperClass()) {
            if (THREAD_CLASS.equals(currentClass.getInternalName()) || RUNNABLE_CLASS.equals(currentClass.getInternalName())) {
                return true;
            }
            for (AsmClass implementedInterface : currentClass.getImplementedInterfaces()) {
                if (!RUNNABLE_CLASS.equals(implementedInterface.getInternalName())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "S1217 rule";
    }
}

