/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1163", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ThrowsFromFinallyCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.THROW_STATEMENT});
    }

    public void visitNode(AstNode node) {
        if (ThrowsFromFinallyCheck.isInFinally(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Refactor this code to not throw exceptions in finally blocks.", node, new Object[0]);
        }
    }

    private static boolean isInFinally(AstNode node) {
        return ThrowsFromFinallyCheck.getFirstAncestor(node, (AstNodeType)JavaGrammar.FINALLY_, (AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).is(new AstNodeType[]{JavaGrammar.FINALLY_});
    }

    private static AstNode getFirstAncestor(AstNode node, AstNodeType type1, AstNodeType type2) {
        AstNode result;
        for (result = node.getParent(); result != null && !result.is(new AstNodeType[]{type1, type2}); result = result.getParent()) {
        }
        return result;
    }
}

