/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00107", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class TooManyParameters_S00107_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S00107";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S00107");
    private static final int DEFAULT_MAXIMUM = 7;
    @RuleProperty(key="maximumMethodParameters", defaultValue="7")
    public int maximum = 7;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        int count = tree.parameters().size();
        if (count > this.maximum) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Method has " + count + " parameters, which is greater than " + this.maximum + " authorized.");
        }
        super.visitMethod(tree);
    }
}

