/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="TrailingCommentCheck", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class TrailingCommentCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^\\s*+[^\\s]++$";
    private static final Set<String> EXCLUDED_PATTERNS = ImmutableSet.of((Object)"NOSONAR", (Object)"NOPMD", (Object)"CHECKSTYLE:");
    @RuleProperty(key="legalCommentPattern", defaultValue="^\\s*+[^\\s]++$")
    public String legalCommentPattern = "^\\s*+[^\\s]++$";
    private Pattern pattern;
    private int previousTokenLine;

    public void visitFile(AstNode astNode) {
        this.previousTokenLine = -1;
        this.pattern = Pattern.compile(this.legalCommentPattern);
    }

    public void visitToken(Token token) {
        if (token.getLine() != this.previousTokenLine) {
            for (Trivia trivia : token.getTrivia()) {
                if (!trivia.isComment() || trivia.getToken().getLine() != this.previousTokenLine) continue;
                String comment = trivia.getToken().getValue();
                String string = comment = comment.startsWith("//") ? comment.substring(2) : comment.substring(2, comment.length() - 2);
                if (this.pattern.matcher(comment = comment.trim()).matches() || this.containsExcludedPattern(comment)) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Move this trailing comment on the previous empty line.", this.previousTokenLine, new Object[0]);
            }
        }
        this.previousTokenLine = token.getLine();
    }

    private boolean containsExcludedPattern(String comment) {
        for (String pattern : EXCLUDED_PATTERNS) {
            if (!StringUtils.containsIgnoreCase((String)comment, (String)pattern)) continue;
            return true;
        }
        return false;
    }
}

