/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1481", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedLocalVariableCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1481";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1481");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (member.is(Tree.Kind.VARIABLE)) {
                super.visitVariable((VariableTree)member);
                continue;
            }
            this.scan(member);
        }
    }

    public void visitMethod(MethodTree tree) {
        this.scan((Tree)tree.modifiers());
        this.scan(tree.typeParameters());
        this.scan(tree.returnType());
        for (VariableTree parameter : tree.parameters()) {
            super.visitVariable(parameter);
        }
        this.scan((Tree)tree.defaultValue());
        this.scan((Tree)tree.block());
    }

    public void visitCatch(CatchTree tree) {
        super.visitVariable(tree.parameter());
        this.scan((Tree)tree.block());
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        AstNode astNode = ((JavaTree)tree).getAstNode();
        AstNode variableAstNode = astNode.is(new AstNodeType[]{JavaGrammar.RESOURCE}) || astNode.is(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETER}) ? astNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR, JavaGrammar.VARIABLE_DECLARATOR_ID}) : astNode;
        AstNode identifierAstNode = variableAstNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        SemanticModel semanticModel = (SemanticModel)this.context.getSemanticModel();
        Symbol symbol = semanticModel.getSymbol(identifierAstNode);
        if (symbol != null && semanticModel.getUsages(symbol).isEmpty()) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Remove this unused \"" + tree.simpleName() + "\" local variable.");
        }
    }
}

