/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1604", priority=Priority.MAJOR, tags={"java8"})
public class AnonymousClassShouldBeLambdaCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1604";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1604");
    private JavaFileScannerContext context;
    private List<IdentifierTree> enumConstants;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.enumConstants = Lists.newArrayList();
        this.scan((Tree)context.getTree());
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.enumConstants.add(tree.simpleName());
        super.visitEnumConstant(tree);
        this.enumConstants.remove(tree.simpleName());
    }

    public void visitNewClass(NewClassTree tree) {
        super.visitNewClass(tree);
        if (tree.classBody() != null) {
            List members = tree.classBody().members();
            if (!this.enumConstants.contains(tree.identifier()) && members.size() == 1 && ((Tree)members.get(0)).is(Tree.Kind.METHOD)) {
                this.context.addIssue((Tree)tree, RULE, "Make this anonymous inner class a lambda");
            }
        }
    }
}

