/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1188", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AnonymousClassesTooBigCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1188";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1188");
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(defaultValue="20")
    public int max = 20;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitNewClass(NewClassTree tree) {
        int lines;
        if (tree.classBody() != null && (lines = this.getNumberOfLines(tree.classBody())) > this.max) {
            this.context.addIssue((Tree)tree, RULE, "Reduce this anonymous class number of lines from " + lines + " to at most " + this.max + ", or make it a named class.");
        }
        super.visitNewClass(tree);
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        int lines = this.getNumberOfLines(((JavaTree)lambdaExpressionTree.body()).getAstNode());
        if (lines > this.max) {
            this.context.addIssue((Tree)lambdaExpressionTree, RULE, "Reduce this lambda expression number of lines from " + lines + " to at most " + this.max + ".");
        }
        super.visitLambdaExpression(lambdaExpressionTree);
    }

    private int getNumberOfLines(ClassTree classTree) {
        AstNode node = ((JavaTree)classTree).getAstNode();
        if (!node.is(new AstNodeType[]{JavaGrammar.CLASS_BODY})) {
            node = node.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_BODY});
        }
        return this.getNumberOfLines(node);
    }

    private int getNumberOfLines(AstNode node) {
        return node.getLastChild().getTokenLine() - node.getTokenLine() + 1;
    }
}

