/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LowerCaseLongSuffixCheck", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class LowerCaseLongSuffixCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaTokenType.LONG_LITERAL});
    }

    public void visitNode(AstNode node) {
        if (node.getTokenOriginalValue().endsWith("l")) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this lower case \"l\" long suffix by an upper case \"L\".", node, new Object[0]);
        }
    }
}

