/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1221", priority=Priority.CRITICAL, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class MethodNamedHashcodeCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        MethodHelper.subscribe((SquidAstVisitor)this);
    }

    public void visitNode(AstNode node) {
        MethodHelper methodHelper = new MethodHelper(node);
        if ("hashcode".equals(methodHelper.getName().getTokenOriginalValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Either override Object.hashCode(), or totally rename the method to prevent any confusion.", methodHelper.getName(), new Object[0]);
        }
    }
}

