/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1148", priority=Priority.CRITICAL, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class PrintStackTraceCalledWithoutArgumentCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.PRIMARY});
    }

    public void visitNode(AstNode node) {
        if (PrintStackTraceCalledWithoutArgumentCheck.isPrintStackTraceCall(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Use a logger to log this exception.", node, new Object[0]);
        }
    }

    private static boolean isPrintStackTraceCall(AstNode node) {
        AstNode identifierSuffix = node.getFirstChild(new AstNodeType[]{JavaGrammar.IDENTIFIER_SUFFIX});
        return identifierSuffix != null && PrintStackTraceCalledWithoutArgumentCheck.hasArgumentIdentifierSuffix(identifierSuffix) && PrintStackTraceCalledWithoutArgumentCheck.isPrintStackTraceQualifiedIdentifier(node.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}));
    }

    private static boolean hasArgumentIdentifierSuffix(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARGUMENTS});
    }

    private static boolean isPrintStackTraceQualifiedIdentifier(AstNode node) {
        return "printStackTrace".equals(node.getLastChild().getTokenOriginalValue());
    }
}

