/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1143", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class ReturnInFinallyCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.RETURN_STATEMENT});
    }

    public void visitNode(AstNode node) {
        if (ReturnInFinallyCheck.isInFinally(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this return statement from this finally block.", node, new Object[0]);
        }
    }

    private static boolean isInFinally(AstNode node) {
        AstNode ancestor = ReturnInFinallyCheck.getFirstAncestor(node, (AstNodeType)JavaGrammar.FINALLY_, (AstNodeType)JavaGrammar.CLASS_BODY);
        return ancestor != null && ancestor.is(new AstNodeType[]{JavaGrammar.FINALLY_});
    }

    private static AstNode getFirstAncestor(AstNode node, AstNodeType type1, AstNodeType type2) {
        for (AstNode ancestor = node.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (ancestor.getType() != type1 && ancestor.getType() != type2) continue;
            return ancestor;
        }
        return null;
    }
}

