/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1132", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class StringLiteralInsideEqualsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.SELECTOR});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.PRIMARY});
    }

    public void visitNode(AstNode node) {
        String literal;
        if (StringLiteralInsideEqualsCheck.isEquals(node) && (literal = StringLiteralInsideEqualsCheck.getStringLiteralArgument(node)) != null) {
            this.getContext().createLineViolation((CodeCheck)this, "Move the " + literal + " string literal on the left side of this string comparison.", node, new Object[0]);
        }
    }

    private static boolean isEquals(AstNode node) {
        return StringLiteralInsideEqualsCheck.isSelectorEquals(node) || StringLiteralInsideEqualsCheck.isQualifiedIdentifierEquals(node);
    }

    private static boolean isSelectorEquals(AstNode node) {
        AstNode identifier = node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        return identifier != null && StringLiteralInsideEqualsCheck.isEqualsMethod(identifier.getTokenOriginalValue());
    }

    private static boolean isQualifiedIdentifierEquals(AstNode node) {
        AstNode qualifiedIdentifier = node.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER});
        return qualifiedIdentifier != null && StringLiteralInsideEqualsCheck.isEqualsMethod(qualifiedIdentifier.getLastToken().getOriginalValue());
    }

    private static boolean isEqualsMethod(String s) {
        return "equals".equals(s) || "equalsIgnoreCase".equals(s);
    }

    private static String getStringLiteralArgument(AstNode node) {
        AstNode arguments = StringLiteralInsideEqualsCheck.getArgumentsNode(node);
        if (arguments == null || arguments.hasDirectChildren(new AstNodeType[]{JavaPunctuator.COMMA})) {
            return null;
        }
        AstNode expression = arguments.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION});
        return expression != null && expression.getToken().getOriginalValue().startsWith("\"") && expression.getToken().equals(expression.getLastToken()) ? expression.getTokenOriginalValue() : null;
    }

    private static AstNode getArgumentsNode(AstNode node) {
        AstNode identifierSuffix;
        AstNode result = node.is(new AstNodeType[]{JavaGrammar.PRIMARY}) ? ((identifierSuffix = node.getFirstChild(new AstNodeType[]{JavaGrammar.IDENTIFIER_SUFFIX})) == null ? null : identifierSuffix.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS})) : node.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS});
        return result;
    }
}

