/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1118", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UtilityClassWithPublicConstructorCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_BODY});
    }

    public void visitNode(AstNode node) {
        if (!UtilityClassWithPublicConstructorCheck.extendsAnotherClass(node) && UtilityClassWithPublicConstructorCheck.hasStaticMembers(node) && !UtilityClassWithPublicConstructorCheck.hasInstanceMembers(node)) {
            boolean hasImplicitPublicConstructor = true;
            for (AstNode explicitConstructor : UtilityClassWithPublicConstructorCheck.getExplicitConstructors(node)) {
                hasImplicitPublicConstructor = false;
                if (!UtilityClassWithPublicConstructorCheck.isPublicConstructor(explicitConstructor)) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Hide this public constructor.", explicitConstructor, new Object[0]);
            }
            if (hasImplicitPublicConstructor) {
                this.getContext().createLineViolation((CodeCheck)this, "Add a private constructor to hide the implicit public one.", node, new Object[0]);
            }
        }
    }

    private static boolean extendsAnotherClass(AstNode node) {
        return node.getParent().hasDirectChildren(new AstNodeType[]{JavaKeyword.EXTENDS});
    }

    private static boolean hasStaticMembers(AstNode node) {
        for (AstNode member : node.getChildren(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION})) {
            if (!UtilityClassWithPublicConstructorCheck.hasStaticModifier(member)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasStaticModifier(AstNode node) {
        for (AstNode modifier : node.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})) {
            if (!modifier.hasDirectChildren(new AstNodeType[]{JavaKeyword.STATIC})) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInstanceMembers(AstNode node) {
        for (AstNode member : node.getChildren(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION})) {
            if (UtilityClassWithPublicConstructorCheck.isExcludedInstanceMember(member) || UtilityClassWithPublicConstructorCheck.hasStaticModifier(member)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludedInstanceMember(AstNode node) {
        AstNode memberDecl = node.getFirstChild(new AstNodeType[]{JavaGrammar.MEMBER_DECL});
        if (memberDecl == null) {
            return true;
        }
        AstNode constructorOrGeneric = memberDecl.getFirstChild(new AstNodeType[]{JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.GENERIC_METHOD_OR_CONSTRUCTOR_REST});
        return constructorOrGeneric != null && UtilityClassWithPublicConstructorCheck.isConstructor(constructorOrGeneric);
    }

    private static List<AstNode> getExplicitConstructors(AstNode node) {
        ImmutableList.Builder builder = ImmutableList.builder();
        AstSelect query = node.select().children((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).children((AstNodeType)JavaGrammar.MEMBER_DECL).children(new AstNodeType[]{JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.GENERIC_METHOD_OR_CONSTRUCTOR_REST});
        for (AstNode methodOrGeneric : query) {
            if (!UtilityClassWithPublicConstructorCheck.isConstructor(methodOrGeneric)) continue;
            builder.add((Object)methodOrGeneric);
        }
        return builder.build();
    }

    private static boolean isConstructor(AstNode node) {
        return node.is(new AstNodeType[]{JavaGrammar.CONSTRUCTOR_DECLARATOR_REST}) || node.hasDirectChildren(new AstNodeType[]{JavaGrammar.CONSTRUCTOR_DECLARATOR_REST});
    }

    private static boolean isPublicConstructor(AstNode node) {
        return UtilityClassWithPublicConstructorCheck.hasPublicModifier(node.getFirstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION));
    }

    private static boolean hasPublicModifier(AstNode node) {
        for (AstNode modifier : node.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})) {
            if (!modifier.hasDirectChildren(new AstNodeType[]{JavaKeyword.PUBLIC})) continue;
            return true;
        }
        return false;
    }
}

