/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1200", priority=Priority.MAJOR, tags={"brain-overload"})
public class ClassCouplingCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(key="max", defaultValue="20")
    public int max = 20;
    private final Stack<Set<String>> nesting = new Stack();
    private Set<String> types;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION, JavaGrammar.CLASS_TYPE});
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION})) {
            this.nesting.push(this.types);
            this.types = Sets.newHashSet();
        } else if (this.types != null) {
            for (AstNode identifier : node.getChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER})) {
                this.types.add(identifier.getTokenOriginalValue());
            }
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION})) {
            if (this.types.size() > this.max) {
                this.getContext().createLineViolation((CodeCheck)this, "Split this class into smaller and more specialized ones to reduce its dependencies on other classes from " + this.types.size() + " to the maximum authorized " + this.max + " or less.", node, new Object[0]);
            }
            this.types = this.nesting.pop();
        }
    }
}

