/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1488", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class ImmediatelyReturnedVariableCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1488";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1488");
    private static final Map<Tree.Kind, String> MESSAGE_KEYS = ImmutableMap.of((Object)Tree.Kind.THROW_STATEMENT, (Object)"throw", (Object)Tree.Kind.RETURN_STATEMENT, (Object)"return");
    private JavaFileScannerContext context;
    private String lastTypeForMessage;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBlock(BlockTree tree) {
        StatementTree butLastSatement;
        String identifier;
        StatementTree lastSatement;
        String lastStatementIdentifier;
        super.visitBlock(tree);
        List statements = tree.body();
        if (statements.size() > 1 && StringUtils.isNotEmpty((String)(lastStatementIdentifier = this.getReturnOrThrowIdentifier(lastSatement = (StatementTree)statements.get(statements.size() - 1)))) && StringUtils.equals((String)lastStatementIdentifier, (String)(identifier = this.getVariableDeclarationIdentifier(butLastSatement = (StatementTree)statements.get(statements.size() - 2))))) {
            this.context.addIssue((Tree)butLastSatement, RULE, "Immediately " + this.lastTypeForMessage + " this expression instead of assigning it to the temporary variable \"" + identifier + "\".");
        }
    }

    private String getReturnOrThrowIdentifier(StatementTree lastSatementOfBlock) {
        String result = null;
        this.lastTypeForMessage = null;
        ExpressionTree expr = null;
        if (lastSatementOfBlock.is(Tree.Kind.THROW_STATEMENT)) {
            this.lastTypeForMessage = MESSAGE_KEYS.get(Tree.Kind.THROW_STATEMENT);
            expr = ((ThrowStatementTree)lastSatementOfBlock).expression();
        } else if (lastSatementOfBlock.is(Tree.Kind.RETURN_STATEMENT)) {
            this.lastTypeForMessage = MESSAGE_KEYS.get(Tree.Kind.RETURN_STATEMENT);
            expr = ((ReturnStatementTree)lastSatementOfBlock).expression();
        }
        if (expr != null && expr.is(Tree.Kind.IDENTIFIER)) {
            result = ((IdentifierTree)expr).name();
        }
        return result;
    }

    private String getVariableDeclarationIdentifier(StatementTree butLastSatement) {
        String result = null;
        if (butLastSatement.is(Tree.Kind.VARIABLE)) {
            result = ((VariableTree)butLastSatement).simpleName().name();
        }
        return result;
    }
}

