/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ObjectFinalizeOverridenCallsSuperFinalizeCheck", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class ObjectFinalizeOverridenCallsSuperFinalizeCheck
extends SquidCheck<LexerlessGrammar> {
    private AstNode lastSuperFinalizeStatement;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.MEMBER_DECL});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.PRIMARY});
    }

    public void visitNode(AstNode node) {
        if (node.hasDirectChildren(new AstNodeType[]{JavaGrammar.VOID_METHOD_DECLARATOR_REST})) {
            AstNode identifier = node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
            if ("finalize".equals(identifier.getTokenValue())) {
                this.lastSuperFinalizeStatement = null;
            }
        } else if (ObjectFinalizeOverridenCallsSuperFinalizeCheck.isSuperFinalize(node)) {
            this.lastSuperFinalizeStatement = node.getFirstAncestor((AstNodeType)JavaGrammar.STATEMENT);
        }
    }

    private static boolean isSuperFinalize(AstNode node) {
        return node.is(new AstNodeType[]{JavaGrammar.PRIMARY}) && node.hasDirectChildren(new AstNodeType[]{JavaKeyword.SUPER}) && ObjectFinalizeOverridenCallsSuperFinalizeCheck.isFinalizeCallSuffix(node.getFirstChild(new AstNodeType[]{JavaGrammar.SUPER_SUFFIX}));
    }

    private static boolean isFinalizeCallSuffix(AstNode node) {
        AstNode identifier = node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        return identifier != null && "finalize".equals(identifier.getTokenOriginalValue()) && node.hasDirectChildren(new AstNodeType[]{JavaGrammar.ARGUMENTS});
    }

    public void leaveNode(AstNode node) {
        AstNode identifier;
        if (node.hasDirectChildren(new AstNodeType[]{JavaGrammar.VOID_METHOD_DECLARATOR_REST}) && "finalize".equals((identifier = node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER})).getTokenValue())) {
            AstSelect methodBlockStatement = node.select().children((AstNodeType)JavaGrammar.VOID_METHOD_DECLARATOR_REST).children((AstNodeType)JavaGrammar.METHOD_BODY).children((AstNodeType)JavaGrammar.BLOCK).children((AstNodeType)JavaGrammar.BLOCK_STATEMENTS).children((AstNodeType)JavaGrammar.BLOCK_STATEMENT);
            if (this.lastSuperFinalizeStatement == null) {
                this.getContext().createLineViolation((CodeCheck)this, "Add a call to super.finalize() at the end of this Object.finalize() implementation.", identifier, new Object[0]);
            } else if (!this.lastSuperFinalizeStatement.equals(ObjectFinalizeOverridenCallsSuperFinalizeCheck.getLastEffectiveStatement(ObjectFinalizeOverridenCallsSuperFinalizeCheck.getLastBlockStatement((Iterable<AstNode>)methodBlockStatement)))) {
                this.getContext().createLineViolation((CodeCheck)this, "Move this super.finalize() call to the end of this Object.finalize() implementation.", this.lastSuperFinalizeStatement, new Object[0]);
            }
        }
    }

    private static AstNode getLastBlockStatement(Iterable<AstNode> blockStatements) {
        AstNode result = null;
        for (AstNode blockStatement : blockStatements) {
            AstNode statement = blockStatement.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT});
            if (statement == null) continue;
            result = statement;
        }
        return result;
    }

    private static AstNode getLastEffectiveStatement(AstNode node) {
        AstNode tryStatement = node.getFirstChild(new AstNodeType[]{JavaGrammar.TRY_STATEMENT});
        if (tryStatement == null) {
            return node;
        }
        AstSelect query = tryStatement.select().children((AstNodeType)JavaGrammar.FINALLY_).children((AstNodeType)JavaGrammar.BLOCK).children((AstNodeType)JavaGrammar.BLOCK_STATEMENTS).children((AstNodeType)JavaGrammar.BLOCK_STATEMENT);
        return ObjectFinalizeOverridenCallsSuperFinalizeCheck.getLastBlockStatement((Iterable<AstNode>)query);
    }
}

