/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ObjectFinalizeOverridenCheck", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ObjectFinalizeOverridenCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.MEMBER_DECL});
    }

    public void visitNode(AstNode node) {
        if (ObjectFinalizeOverridenCheck.isFinalizeMethodMember(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Do not override the Object.finalize() method.", node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}), new Object[0]);
        }
    }

    private static boolean isFinalizeMethodMember(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaGrammar.VOID_METHOD_DECLARATOR_REST}) && "finalize".equals(node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenOriginalValue());
    }
}

