/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1158", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ToStringUsingBoxingCheck
extends SquidCheck<LexerlessGrammar> {
    private static final Set<String> PRIMITIVE_WRAPPERS = ImmutableSet.of((Object)"Byte", (Object)"Short", (Object)"Integer", (Object)"Long", (Object)"Float", (Object)"Double", (Object[])new String[]{"Character", "Boolean"});

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.UNARY_EXPRESSION, JavaGrammar.UNARY_EXPRESSION_NOT_PLUS_MINUS});
    }

    public void visitNode(AstNode node) {
        String newlyCreatedClassName;
        if (ToStringUsingBoxingCheck.hasToStringSelector(node) && PRIMITIVE_WRAPPERS.contains(newlyCreatedClassName = ToStringUsingBoxingCheck.getNewlyCreatedClassName(node))) {
            this.getContext().createLineViolation((CodeCheck)this, "Call the static method " + newlyCreatedClassName + ".toString(...) instead of instantiating a temporary object to perform this to string conversion.", node, new Object[0]);
        }
    }

    private static boolean hasToStringSelector(AstNode node) {
        AstNode selector = node.getFirstChild(new AstNodeType[]{JavaGrammar.SELECTOR});
        return selector != null && selector.hasDirectChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER}) && "toString".equals(selector.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenOriginalValue());
    }

    private static String getNewlyCreatedClassName(AstNode node) {
        AstNode primary = node.getFirstChild(new AstNodeType[]{JavaGrammar.PRIMARY});
        AstNode creator = primary.getFirstChild(new AstNodeType[]{JavaGrammar.CREATOR});
        return creator == null ? null : ToStringUsingBoxingCheck.getSimpleCreatedName(creator.getFirstChild(new AstNodeType[]{JavaGrammar.CREATED_NAME}));
    }

    private static String getSimpleCreatedName(AstNode node) {
        return node == null || !node.getToken().equals(node.getLastToken()) ? null : node.getTokenOriginalValue();
    }
}

