/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1611", priority=Priority.MINOR, tags={"java8"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class LambdaOptionalParenthesisCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.LAMBDA_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        LambdaExpressionTree let = (LambdaExpressionTree)tree;
        if (let.openParenToken() != null && let.parameters().size() == 1) {
            VariableTree param = (VariableTree)let.parameters().get(0);
            String ident = param.simpleName().name();
            this.addIssue((Tree)param, "Remove the parentheses around the \"" + ident + "\" parameter");
        }
    }
}

