/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="MethodCyclomaticComplexity", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class MethodComplexityCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 10;
    @RuleProperty(defaultValue="10")
    private int max = 10;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        int complexity = this.context.getComplexity((Tree)methodTree);
        if (complexity > this.max) {
            this.addIssue(tree, MessageFormat.format("The Cyclomatic Complexity of this method \"{0}\" is {1,number,integer} which is greater than {2,number,integer} authorized.", methodTree.simpleName().name(), complexity, this.max));
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

