/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RightCurlyBraceSameLineAsNextBlockCheck", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RightCurlyBraceSameLineAsNextBlockCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final Set<String> NEXT_BLOCKS = ImmutableSet.of((Object)"else", (Object)"catch", (Object)"finally");
    private boolean lastTokenIsRightCurlyBrace;
    private int lastTokenLine;

    public void visitFile(AstNode astNode) {
        this.lastTokenIsRightCurlyBrace = false;
        this.lastTokenLine = -1;
    }

    public void visitToken(Token token) {
        if (this.lastTokenIsRightCurlyBrace && this.lastTokenLine != token.getLine() && NEXT_BLOCKS.contains(token.getValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this \"" + token.getValue() + "\" on the same line that the previous closing curly brace.", token, new Object[0]);
        }
        this.lastTokenIsRightCurlyBrace = "}".equals(token.getValue());
        this.lastTokenLine = token.getLine();
    }
}

